/*#include "texture.h"
#include "inifile.h"

Texture::Texture()
{
	m_pTexture		= NULL;
	m_pVertexBuffer = NULL;
	m_byOpacity		= 255;
	m_byR			= 255;
	m_byG			= 255;
	m_byB			= 255;
	m_bLoaded		= false;
	m_x				= 0;
	m_y				= 0;
}

Texture::Texture(const string &szFilename)
{
	Texture();
	Create(szFilename);
}

Texture::~Texture()
{
	Destroy();
}

bool Texture::Create(const string &szFilename)
{
	if (m_bLoaded)
		Destroy();

	// load the texture from the disk
	g_hResult = D3DXCreateTextureFromFileExA(g_d3d.m_pD3DDevice,			// d3d device
											("D:\\" +  szFilename).c_str(),	// filename
											 D3DX_DEFAULT, D3DX_DEFAULT,	// width/height
											 D3DX_DEFAULT,					// mipmaps
											 0,								// usage
											 D3DFMT_A8R8G8B8,				// format
											 D3DPOOL_MANAGED,				// memory class
											 D3DX_DEFAULT,					// texture filter
											 D3DX_DEFAULT,					// mipmapping
											 0,								// colorkey
											 &m_imageInfo,					// image info
											 NULL,							// pallete
											 &m_pTexture);					// texture

	if (FAILED(g_hResult))
		return false;

	// create a vertex buffer for the quad that will display the texture
	g_hResult = g_d3d.m_pD3DDevice->CreateVertexBuffer(4 * sizeof(CustomVertex),
													   D3DUSAGE_WRITEONLY, 
													   D3DFVF_CUSTOMVERTEX,
													   D3DPOOL_MANAGED, &m_pVertexBuffer);
	if (FAILED(g_hResult))
	{
		m_pTexture->Release();
		return false;
	}

	m_bLoaded = true;

	return true;
}

bool Texture::Create(dword width, dword height)
{
	if (m_bLoaded)
		Destroy();

    g_hResult = g_d3d.m_pD3DDevice->CreateTexture(width, height, 1, 0, 
												  D3DFMT_A8R8G8B8, D3DPOOL_MANAGED, 
												  &m_pTexture);
	
	if (FAILED(g_hResult))
		return false;

	m_imageInfo.Width = width;
	m_imageInfo.Height = height;
	m_imageInfo.Format = D3DFMT_A8R8G8B8;

	// create a vertex buffer for the quad that will display the texture
	g_hResult = g_d3d.m_pD3DDevice->CreateVertexBuffer(4 * sizeof(CustomVertex),
													   D3DUSAGE_WRITEONLY, 
													   D3DFVF_CUSTOMVERTEX,
													   D3DPOOL_MANAGED, &m_pVertexBuffer);
	if (FAILED(g_hResult))
	{
		m_pTexture->Release();
		return false;
	}

	m_bLoaded = true;

	return true;
}

void Texture::Destroy()
{
	// free the vertex buffer
	if (m_pVertexBuffer)
	{
		m_pVertexBuffer->Release();
		m_pVertexBuffer = NULL;
	}

	// free the texture
	if (m_pTexture)
	{
		m_pTexture->Release();
		m_pTexture = NULL;
	}

	m_bLoaded = false;
}

bool Texture::IsLoaded()
{
	return m_bLoaded;
}

bool Texture::Render()
{
	return Render(m_x, m_y);
}

bool Texture::Render(int x, int y)
{
	return Render(x, y, m_imageInfo.Width, m_imageInfo.Height);
}

bool Texture::Render(int x, int y, dword w, dword h)
{
	if (m_pTexture == NULL || m_pVertexBuffer == NULL || m_bLoaded == false)
		return false;

	float fX = static_cast<float>(x);
	float fY = static_cast<float>(y);

    // create the new vertices
	CustomVertex newVerts[] =
    {
		// x,		y,			z,	  color,					    u ,v
        {fX,		fY,			0.0f, D3DCOLOR_ARGB(m_byOpacity, m_byR, m_byG, m_byB), 0, 0},
		{fX + w,	fY,			0.0f, D3DCOLOR_ARGB(m_byOpacity, m_byR, m_byG, m_byB), 1, 0}, 
        {fX + w,	fY + h,		0.0f, D3DCOLOR_ARGB(m_byOpacity, m_byR, m_byG, m_byB), 1, 1},
		{fX,		fY + h,		0.0f, D3DCOLOR_ARGB(m_byOpacity, m_byR, m_byG, m_byB), 0, 1}
    };

	// load the existing vertices
	CustomVertex *pCurVerts;

	g_hResult = m_pVertexBuffer->Lock(0, 0, (byte **)&pCurVerts, 0);

	if (FAILED(g_hResult))
		return false;

	// copy the new verts over the old verts
	memcpy(pCurVerts, newVerts, 4 * sizeof(CustomVertex));

	m_pVertexBuffer->Unlock();


    g_d3d.m_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    g_d3d.m_pD3DDevice->SetRenderState(D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA);
    g_d3d.m_pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

	// also blend the texture with the set alpha value
	g_d3d.m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_MODULATE);
	g_d3d.m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);
	g_d3d.m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_TEXTURE);

	// draw the quad
	g_d3d.m_pD3DDevice->SetTexture(0, m_pTexture);
    g_d3d.m_pD3DDevice->SetStreamSource(0, m_pVertexBuffer, sizeof(CustomVertex));
    g_d3d.m_pD3DDevice->SetVertexShader(D3DFVF_CUSTOMVERTEX);
	g_d3d.m_pD3DDevice->DrawPrimitive(D3DPT_QUADLIST, 0, 1);

	return true;
}

void Texture::SetOpacity(byte opacity)
{
	m_byOpacity = opacity;
}

void Texture::SetTint(byte r, byte g, byte b)
{
	m_byR = r;
	m_byG = g;
	m_byB = b;
}

void Texture::MoveTo(int x, int y)
{
	m_x = x;
	m_y = y;
}

dword Texture::GetWidth()
{
	if (m_pTexture == NULL || m_pVertexBuffer == NULL)
		return 0;

	return m_imageInfo.Width;
}

dword Texture::GetHeight()
{
	if (m_pTexture == NULL || m_pVertexBuffer == NULL)
		return 0;

	return m_imageInfo.Height;
}

byte Texture::GetOpacity()
{
	return m_byOpacity;
}

D3DTexture *Texture::GetTexture()
{
	return m_pTexture;
}
*/